*****This code detAILls how to produce Table 3  in Hambur and La Cava (2018)
*** First portion reads in the Multiple Imputation sample and summarizes
*** Second portion is the code used to Impute - note will overwrite existing boostrap sample

*** Read in MI sample

* Make sure working directory has data file in it
local location ""

*** Read in bootstrap
use "`location'\imputation.dta", clear

summarize, detail

*Net investment
xi: mi estimate, imputations(1 2 to 100) cmdok: xtabond Inv_ppe_st_k l2.lk_ppe l(0/1).d.lrsales l2.lrsales l(1/2).d.imp_lir l3.imp_lir i.year if Inv_ppe_st_k<=Inv_ppe_st_k_p95 & Inv_ppe_st_k>=Inv_ppe_st_k_p5 & year<=2015 & Res!=1, robust

*Gross investment
xi: mi estimate, imputations(1 2 to 100) cmdok: xtabond Inv_ppe_cash_k l2.lk_ppe l(0/1).d.lrsales l2.lrsales l(1/2).d.imp_lir l3.imp_lir i.year if Inv_ppe_cash_k<=Inv_ppe_cash_k_p95 & Inv_ppe_cash_k>=Inv_ppe_cash_k_p5 & year<=2015 & Res!=1, robust


/*
*** Code to do multiple imputation

**Set-up data - 
* Make sure working directory has data file in it
local location ""

* Set to directory with ivreg2 package and rantest package installed
sysdir set PLUS ""

use "`location'\Main_data_file.dta",clear 

*Sort
xtset asxnum year


*Remove varaible without imputation covariates or create them
keep if Q!=.

replace cash=0 if cash==.
replace gearing=0 if debt==0
replace debttoassets=0 if debt==0
replace liquidity_ratio=0 if cash==0

keep if Inv_ppe_st_k!=.
keep if Inv_ppe_cash_k!=.

replace ROE=annual_ebitda/equity if ROE==.

drop if D2D==.


egen last_obs=max(date), by(asxnum)
gen is_last_obs1=0
replace is_last_obs1=1 if date==last_obs
drop last_ob


gen Inv_ppe_st_k_fwd=Inv_ppe_st_k[_n+1]
replace Inv_ppe_st_k_fwd=. if is_last_obs1==1

gen Inv_ppe_cash_k_fwd=Inv_ppe_cash_k[_n+1]
replace Inv_ppe_cash_k_fwd=. if is_last_obs1==1

*Undefined gearing and ROE and liduity ratio if some things zero 
*egen max_gear=max(gearing)

*replace gearing=max_gear if equity==0

egen max_liq=max(liquidity_ratio)
replace liquidity_ratio=max_liq if current_liabilities==.

* Set up imputation sample
mi set mlong

mi register impute irliabtot

mi register regular Q ROA debttoassets small medium neg_eq liquidity_ratio D2D Inv_ppe_st_k Inv_ppe_cash_k risky LM age age_sq assets delist1 delist2 Inv_ppe_st_k_fwd Inv_ppe_cash_k_fwd

* Impute nearest neighbour
*No pool
mi impute pmm irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D  risky LM age age_sq delist1 delist2 , add(100) knn(3) by(year) 
* pool
mi impute pmm irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D risky LM age age_sq delist1 delist2 i.year , add(100) knn(3)



*Impute linear 
mi impute regress irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D  risky LM age age_sq delist1 delist2, add(100) by(year) 

mi impute regress irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D risky LM age age_sq delist1 delist2 i.year, add(100)



* Impute nearest negithbour K=5
mi impute pmm irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D risky LM age age_sq delist1 delist2  , add(100) knn(5) by(year) 

mi impute pmm irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D risky LM age age_sq delist1 delist2 i.year, add(100) knn(5) 


* Ipute truncated
mi impute truncreg irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D  risky LM age age_sq delist1 delist2 , add(100)  by(year) ll(0) ul(20)

mi impute truncreg irliabtot Q assets ROA debttoassets small medium neg_eq liquidity_ratio D2D risky LM age age_sq delist1 delist2 i.year , add(100)  ll(0) ul(20)


mi xtset asxnum year

gen imp_lir=log(irliabtot)

